import os, re, sys, json, urllib.request

REPO = os.environ.get("GITHUB_REPOSITORY")  # e.g. SudoSuOps/trustcat
TOKEN = os.environ.get("GITHUB_TOKEN") or os.environ.get("GH_TOKEN")

if not REPO:
    print("GITHUB_REPOSITORY not set", file=sys.stderr); sys.exit(1)

req = urllib.request.Request(
    f"https://api.github.com/repos/{REPO}/topics",
    headers={
        "Accept": "application/vnd.github+json",
        "Authorization": f"Bearer {TOKEN}" if TOKEN else ""
    }
)
with urllib.request.urlopen(req) as resp:
    data = json.load(resp)
topics = data.get("names", [])

# stable ordering: alpha
topics = sorted(set(topics), key=str.lower)

# build shields row (non-clickable)
def shield_label(t: str) -> str:
    # shields uses '-' as delimiter; escape hyphens by doubling for readability
    return t.replace('-', '--')

badges = ['  <img alt="topic: %s" src="https://img.shields.io/badge/%s-topic-6b7280?style=flat-square">' %
          (t, shield_label(t)) for t in topics]
row = "<p align=\"left\">\n" + "\n".join(badges) + "\n</p>\n"

START = "<!--TOPICS:START-->"
END   = "<!--TOPICS:END-->"

readme_path = "README.md"
try:
    with open(readme_path, "r", encoding="utf-8") as f:
        readme = f.read()
except FileNotFoundError:
    readme = "# TrustCat\n\n"

block = f"{START}\n{row}{END}"

if START in readme and END in readme:
    new = re.sub(re.escape(START) + r".*?" + re.escape(END), block, readme, flags=re.S)
else:
    # append a new Topics section at the end
    new = readme.rstrip() + "\n\n## Topics\n" + block + "\n"

if new != readme:
    with open(readme_path, "w", encoding="utf-8") as f:
        f.write(new)
    print("README updated.")
else:
    print("No change.")
