# TrustCat — Pay-it-Forward AI Second Opinions
Static landing hosted on IPFS/ENS (`trustcat.eth`). Includes privacy-first copy,
donation helpers (USDC on Base), community badges (GitHub/Discord/X/Hugging Face),
and an EAS-ready “Create Job” block.

## Local preview
Open `index.html` or run:
  python3 -m http.server 8081

## Pin to IPFS
  NEW=$(ipfs add -r --cid-version=1 -Q .); ipfs pin add "$NEW"; echo "CID: $NEW"

## Badges

<p align="left">
  <!-- repo/social -->
  <a href="https://github.com/SudoSuOps/trustcat">
    <img alt="GitHub stars" src="https://img.shields.io/github/stars/SudoSuOps/trustcat?style=social">
  </a>
  <a href="https://x.com/trustcatai">
    <img alt="X (Twitter) Follow" src="https://img.shields.io/twitter/follow/trustcatai?style=social">
  </a>
  <a href="https://discord.gg/YsfM6Nt7">
    <img alt="Discord" src="https://img.shields.io/badge/Discord-join-5865F2?logo=discord&logoColor=white">
  </a>
  <a href="https://huggingface.co/Trustcat">
    <img alt="Hugging Face" src="https://img.shields.io/badge/HuggingFace-models-FFD21E?logo=huggingface&logoColor=black">
  </a>

  <!-- stack/topics -->
  <a href="https://ipfs.tech/">
    <img alt="IPFS" src="https://img.shields.io/badge/IPFS-ready-65c2cb?logo=ipfs&logoColor=white">
  </a>
  <a href="https://app.ens.domains/name/trustcat.eth">
    <img alt="ENS" src="https://img.shields.io/badge/ENS-trustcat.eth-3C3C3D?logo=ethereum&logoColor=white">
  </a>
  <a href="https://base.org/">
    <img alt="Base" src="https://img.shields.io/badge/Base-chain-0052FF?logo=base&logoColor=white">
  </a>
  <a href="https://docs.attest.sh/">
    <img alt="EAS" src="https://img.shields.io/badge/EAS-attestations-4C48FF">
  </a>
  <a href="https://monai.io/">
    <img alt="MONAI" src="https://img.shields.io/badge/MONAI-medical%20AI-00B894">
  </a>
  <a href="https://www.dicomstandard.org/">
    <img alt="DICOM" src="https://img.shields.io/badge/DICOM-supported-2E86C1">
  </a>
  <img alt="Medical Imaging" src="https://img.shields.io/badge/medical_imaging-MRI%2FCT-6C5CE7">
  <img alt="Privacy" src="https://img.shields.io/badge/privacy-purge%20%3C%3D%2024h-0EA5E9">
  <img alt="Verifiable Compute" src="https://img.shields.io/badge/verifiable_compute-receipts-22C55E">
  <img alt="GPU" src="https://img.shields.io/badge/GPU-RTX%205090-0F766E">
  <a href="https://www.nvidia.com/">
    <img alt="NVIDIA" src="https://img.shields.io/badge/NVIDIA-enterprise-76B900?logo=nvidia&logoColor=black">
  </a>
  <a href="https://kubernetes.io/">
    <img alt="Kubernetes" src="https://img.shields.io/badge/Kubernetes-fleet-326CE5?logo=kubernetes&logoColor=white">
  </a>
  <a href="https://chain.link/">
    <img alt="Chainlink" src="https://img.shields.io/badge/Chainlink-oracles-2A5ADA?logo=chainlink&logoColor=white">
  </a>
  <a href="https://trustcompute.com">
    <img alt="TrustCompute" src="https://img.shields.io/badge/TrustCompute-GPU%20cloud-FFC000">
  </a>
</p>

## Badges

<p align="left">
  <!-- repo/social -->
  <a href="https://github.com/SudoSuOps/trustcat">
    <img alt="GitHub stars" src="https://img.shields.io/github/stars/SudoSuOps/trustcat?style=social">
  </a>
  <a href="https://x.com/trustcatai">
    <img alt="X (Twitter) Follow" src="https://img.shields.io/twitter/follow/trustcatai?style=social">
  </a>
  <a href="https://discord.gg/YsfM6Nt7">
    <img alt="Discord" src="https://img.shields.io/badge/Discord-join-5865F2?logo=discord&logoColor=white">
  </a>
  <a href="https://huggingface.co/Trustcat">
    <img alt="Hugging Face" src="https://img.shields.io/badge/HuggingFace-models-FFD21E?logo=huggingface&logoColor=black">
  </a>

  <!-- stack/topics -->
  <a href="https://ipfs.tech/">
    <img alt="IPFS" src="https://img.shields.io/badge/IPFS-ready-65c2cb?logo=ipfs&logoColor=white">
  </a>
  <a href="https://app.ens.domains/name/trustcat.eth">
    <img alt="ENS" src="https://img.shields.io/badge/ENS-trustcat.eth-3C3C3D?logo=ethereum&logoColor=white">
  </a>
  <a href="https://base.org/">
    <img alt="Base" src="https://img.shields.io/badge/Base-chain-0052FF?logo=base&logoColor=white">
  </a>
  <a href="https://docs.attest.sh/">
    <img alt="EAS" src="https://img.shields.io/badge/EAS-attestations-4C48FF">
  </a>
  <a href="https://monai.io/">
    <img alt="MONAI" src="https://img.shields.io/badge/MONAI-medical%20AI-00B894">
  </a>
  <a href="https://www.dicomstandard.org/">
    <img alt="DICOM" src="https://img.shields.io/badge/DICOM-supported-2E86C1">
  </a>
  <img alt="Medical Imaging" src="https://img.shields.io/badge/medical_imaging-MRI%2FCT-6C5CE7">
  <img alt="Privacy" src="https://img.shields.io/badge/privacy-purge%20%3C%3D%2024h-0EA5E9">
  <img alt="Verifiable Compute" src="https://img.shields.io/badge/verifiable_compute-receipts-22C55E">
  <img alt="GPU" src="https://img.shields.io/badge/GPU-RTX%205090-0F766E">
  <a href="https://www.nvidia.com/">
    <img alt="NVIDIA" src="https://img.shields.io/badge/NVIDIA-enterprise-76B900?logo=nvidia&logoColor=black">
  </a>
  <a href="https://kubernetes.io/">
    <img alt="Kubernetes" src="https://img.shields.io/badge/Kubernetes-fleet-326CE5?logo=kubernetes&logoColor=white">
  </a>
  <a href="https://chain.link/">
    <img alt="Chainlink" src="https://img.shields.io/badge/Chainlink-oracles-2A5ADA?logo=chainlink&logoColor=white">
  </a>
  <a href="https://trustcompute.com">
    <img alt="TrustCompute" src="https://img.shields.io/badge/TrustCompute-GPU%20cloud-FFC000">
  </a>
</p>

## Links
- Site (ENS): https://trustcat.eth.limo
- Repo: https://github.com/SudoSuOps/trustcat
- X: https://x.com/trustcatai
- Discord: https://discord.gg/YsfM6Nt7
- Hugging Face: https://huggingface.co/Trustcat
- TrustCompute: https://trustcompute.com

## Topics
<p align="left">
  <img alt="topic: ipfs"               src="https://img.shields.io/badge/ipfs-topic-6b7280?style=flat-square">
  <img alt="topic: ens"                src="https://img.shields.io/badge/ens-topic-6b7280?style=flat-square">
  <img alt="topic: base"               src="https://img.shields.io/badge/base-topic-6b7280?style=flat-square">
  <img alt="topic: ethereum"           src="https://img.shields.io/badge/ethereum-topic-6b7280?style=flat-square">
  <img alt="topic: eas"                src="https://img.shields.io/badge/eas-topic-6b7280?style=flat-square">
  <img alt="topic: monai"              src="https://img.shields.io/badge/monai-topic-6b7280?style=flat-square">
  <img alt="topic: dicom"              src="https://img.shields.io/badge/dicom-topic-6b7280?style=flat-square">
  <img alt="topic: medical-imaging"    src="https://img.shields.io/badge/medical--imaging-topic-6b7280?style=flat-square">
  <img alt="topic: privacy"            src="https://img.shields.io/badge/privacy-topic-6b7280?style=flat-square">
  <img alt="topic: verifiable-compute" src="https://img.shields.io/badge/verifiable--compute-topic-6b7280?style=flat-square">
  <img alt="topic: gpu"                src="https://img.shields.io/badge/gpu-topic-6b7280?style=flat-square">
  <img alt="topic: nvidia"             src="https://img.shields.io/badge/nvidia-topic-6b7280?style=flat-square">
  <img alt="topic: kubernetes"         src="https://img.shields.io/badge/kubernetes-topic-6b7280?style=flat-square">
  <img alt="topic: chainlink"          src="https://img.shields.io/badge/chainlink-topic-6b7280?style=flat-square">
  <img alt="topic: trustcompute"       src="https://img.shields.io/badge/trustcompute-topic-6b7280?style=flat-square">
  <img alt="topic: trustcat"           src="https://img.shields.io/badge/trustcat-topic-6b7280?style=flat-square">
</p>

## Topics
<!--TOPICS:START-->
<p align="left">
  <img alt="topic: base" src="https://img.shields.io/badge/base-topic-6b7280?style=flat-square">
  <img alt="topic: chainlink" src="https://img.shields.io/badge/chainlink-topic-6b7280?style=flat-square">
  <img alt="topic: dicom" src="https://img.shields.io/badge/dicom-topic-6b7280?style=flat-square">
  <img alt="topic: eas" src="https://img.shields.io/badge/eas-topic-6b7280?style=flat-square">
  <img alt="topic: ens" src="https://img.shields.io/badge/ens-topic-6b7280?style=flat-square">
  <img alt="topic: ethereum" src="https://img.shields.io/badge/ethereum-topic-6b7280?style=flat-square">
  <img alt="topic: gpu" src="https://img.shields.io/badge/gpu-topic-6b7280?style=flat-square">
  <img alt="topic: ipfs" src="https://img.shields.io/badge/ipfs-topic-6b7280?style=flat-square">
  <img alt="topic: kubernetes" src="https://img.shields.io/badge/kubernetes-topic-6b7280?style=flat-square">
  <img alt="topic: medical-imaging" src="https://img.shields.io/badge/medical--imaging-topic-6b7280?style=flat-square">
  <img alt="topic: monai" src="https://img.shields.io/badge/monai-topic-6b7280?style=flat-square">
  <img alt="topic: nvidia" src="https://img.shields.io/badge/nvidia-topic-6b7280?style=flat-square">
  <img alt="topic: privacy" src="https://img.shields.io/badge/privacy-topic-6b7280?style=flat-square">
  <img alt="topic: trustcat" src="https://img.shields.io/badge/trustcat-topic-6b7280?style=flat-square">
  <img alt="topic: trustcompute" src="https://img.shields.io/badge/trustcompute-topic-6b7280?style=flat-square">
  <img alt="topic: verifiable-compute" src="https://img.shields.io/badge/verifiable--compute-topic-6b7280?style=flat-square">
</p>
<!--TOPICS:END-->

## Models (Hugging Face)
<!--HF:START-->
<p align="left">
  <a href="https://huggingface.co/Trustcat" target="_blank" rel="noopener">
    <img alt="HF Models"   src="https://img.shields.io/badge/Models-0-FFD21E?logo=huggingface&logoColor=black">
  </a>
  <a href="https://huggingface.co/Trustcat" target="_blank" rel="noopener">
    <img alt="HF Datasets" src="https://img.shields.io/badge/Datasets-0-0ea5e9?logo=huggingface&logoColor=black">
  </a>
  <a href="https://huggingface.co/Trustcat" target="_blank" rel="noopener">
    <img alt="HF Spaces"   src="https://img.shields.io/badge/Spaces-0-a78bfa?logo=huggingface&logoColor=black">
  </a>
</p>
<!--HF:END-->

## CI Status
<p>
  <img alt="Topics badges sync"
       src="https://github.com/SudoSuOps/trustcat/actions/workflows/update-topics.yml/badge.svg">
  <img alt="HF badges sync"
       src="https://github.com/SudoSuOps/trustcat/actions/workflows/update-hf.yml/badge.svg">
</p>
